import java.io.*;
import java.net.ServerSocket;
import java.net.Socket;

// Press Shift twice to open the Search Everywhere dialog and type `show whitespaces`,
// then press Enter. You can now see whitespace characters in your code.
public class Main {
    public static void main(String[] args) {

        try {
            Socket skCliente;
            System.out.println("Creando el server socket");

            //ServerSocket, es crear un servicio, con un puerto determinado.
            ServerSocket skServidor = new ServerSocket(5000);

            System.out.println("Esperando al cliente");

            skCliente = skServidor.accept(); //Bloqueante (Flujo detenido) hasta que haya una petición
            System.out.println("Atendiendo al cliente");

            //Bloque [Solicitud de datos]
            InputStream aux = skCliente.getInputStream(); //Corazón
            DataInputStream flujo_entrada = new DataInputStream(aux); //Mente
            //Fin Bloque

            //Bloque [Envío de datos]
            OutputStream aux2 = skCliente.getOutputStream();
            DataOutputStream flujo_salida = new DataOutputStream(aux2);
            //Fin Bloque.

            int lectura = flujo_entrada.readInt();
            System.out.println("El cliente ha pedido la operación "+lectura);
            switch (lectura){
                case 1:
                    int operando1 = flujo_entrada.readInt();
                    int operando2 = flujo_entrada.readInt();
                    int suma = operando1 + operando2;
                    flujo_salida.writeInt(suma);
                case 2:
                    System.out.println("Operación raíz solicitada");
                case 4:
                    System.out.println("Operación desconexión solicitada");
                    int port = skCliente.getLocalPort();
                    System.out.println("Desconecto el socket del cliente del puerto "+port);
                    skCliente.close();
                default:
                    System.out.println("Operación no reconocida");
            }
        } catch (IOException e) {
            System.out.println(e.getMessage());
        }


    }
}